from flask import Flask, jsonify
from threading import Thread
from playwright.sync_api import sync_playwright
import pymysql
from sqlalchemy import create_engine, text

DB_HOST="107.161.183.162"
DB_USER="rimecomb"
DB_PASSWORD="dA2c10pyHh8N"
DB_NAME="rimecomb_test_rpa"

engine = create_engine(f"mysql+pymysql://{DB_USER}:{DB_PASSWORD}@{DB_HOST}/{DB_NAME}")

app = Flask(__name__)

def save_log(status, message):
    with engine.connect() as connection:
        query = text("INSERT INTO logs (status, message) VALUES (:status, :message)")
        connection.execute(query, {"status": status, "message": message})
        connection.commit()

def run_rpa():
    try:
        save_log("running", "RPA is running")

        with sync_playwright() as p:
            browser = p.chromium.launch(headless=True)
            page = browser.new_page()
            page.goto("https://www.google.com")
            page.screenshot(path="screenshot.png")

            save_log("success", "RPA is done")
            browser.close()
    except Exception as e:
        save_log("error", str(e))

@app.route("/run-rpa", methods=["GET"])
def run_rpa_endpoint():
    thread = Thread(target=run_rpa)
    thread.start()
    return jsonify({"message": "RPA iniciado em segundo plano"}), 200

@app.route("/logs", methods=["GET"])
def get_logs():
    with engine.connect() as connection:
        result = connection.execute(text("SELECT * FROM logs ORDER BY timestamp DESC"))
        logs = [{"id": row[0], "status": row[1], "message": row[2], "timestamp": row[3]} for row in result]
    return jsonify(logs)

if __name__ == "__main__":
    app.run(host="0.0.0.0", port=5000, debug=True)